<?php

declare(strict_types=1);

require __DIR__ . '/../vendor/autoload.php';

use Svenya\TicketIdGenerator\CodeGenerator;

function printSection(string $title, array $items): void
{
    echo "\n=== {$title} ===\n";
    foreach ($items as $item) {
        echo $item . "\n";
    }
}

// Config
$length = 8;
$count  = 10;

// Barcode codes (uppercase, excludes I/O/L)
$barcode = (new CodeGenerator(['length' => $length, 'count' => $count]))->generate('barcode');

// Code (mixed case, excludes I/O/L/l)
$code  = (new CodeGenerator(['length' => $length, 'count' => $count]))->generate('code');

// Numeric IDs (10 digits)
$numeric = (new CodeGenerator(['count' => $count]))->generate('numeric');

printSection('Barcode codes (uppercase)', $barcode);
printSection('Code (mixed case)', $code);
printSection('Numeric IDs (10 digits)', $numeric);

echo "\nDone.\n";
